-- load all otui files, order doesn't matter
local configName = modules.game_bot.contentsPanel.config:getCurrentOption().text

local configFiles = g_resources.listDirectoryFiles("/bot/" .. configName .. "/vBot", true, false)
for i, file in ipairs(configFiles) do
  local ext = file:split(".")
  if ext[#ext]:lower() == "ui" or ext[#ext]:lower() == "otui" then
    g_ui.importStyle(file)
  end
end

local function loadScript(name)
  return dofile("/vBot/" .. name .. ".lua")
end

if not PlayerVocation or not PlayerVocation.detected then
  print("SmartHealer: Waiting for vocation detection...")
  loadScript("vlib")
  loadScript("_checkVcc")
end

if not PlayerVocation or not PlayerVocation.detected then
  print("SmartHealer: Waiting for vocation detection...")
else
  local luaFiles = {
    "vlib",
    "smartHealer",
    "main",
    "items",
    "new_cavebot_lib",
    "configs",
    "extras",
    "cavebot",    
    "fullChase",
    "tools",
    "hold_target",
    "smartUE",
    "alarms",
    "Conditions",
    "Equipper",
    "ingame_editor",
    "exeta",
    "npc_talk",
    "xeno_menu",
    "playerlist",
    "new_healer",
    "auto_follow",
    "eat_food",
    "swapRing",
    "swapAmulet"
}

  for i, file in ipairs(luaFiles) do
    loadScript(file)
  end
end

setDefaultTab("Main")
